<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementorChild
 */

/**
 * Load child theme css and optional scripts
 *
 * @return void
 */
function hello_elementor_child_enqueue_scripts() {
	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		'1.0.0'
	);
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_enqueue_scripts', 20 );
add_action( 'elementor_pro/forms/new_record', function( $record, $ajax_handler ) {
    
    $form_name = $record->get_form_settings('form_name');

      if ('individual_form' == $form_name){
    
        //if its the data submitted from individual_form
        $raw_fields = $record->get( 'fields' );
        $fields = [];
        foreach ( $raw_fields as $id => $field ) {
              $fields[ $id ] = $field['value'];
        }
    
        global $wpdb;
        $output['success'] = $wpdb->insert('membership_data',
        array(
          'form_type' => $fields['form_type'],
          'name' => $fields['name'],
          'gender' => $fields['gender'],
          'pronoun' => $fields['pronoun'],
          'age_group' => $fields['age_group'],
          'email' => $fields['email'],
          'phone' => $fields['phone'],
          'location' => $fields['location'],
          'location_specific' => $fields['location_specific'],
          'area_of_work' => $fields['area_of_work'],
          'area_specify' => $fields['area_specify'],
          'feminist' => $fields['feminist'],
          'contribution' => $fields['contribution'],
          'gain' => $fields['gain']
          ));
    
        $ajax_handler->add_response_data( true, $output );
    
      }elseif ('network_form' == $form_name) {
    
        $raw_fields = $record->get( 'fields' );
        $fields = [];
        foreach ( $raw_fields as $id => $field ) {
              $fields[ $id ] = $field['value'];
        }
    
        global $wpdb;
        $output['success'] = $wpdb->insert('group_membership_data',
        array(
          'form_type' => $fields['form_type'],
          'org_name' => $fields['org_name'],
          'year_est' => $fields['year_est'],
          'grp_email' => $fields['grp_email'],
          'grp_phone' => $fields['grp_phone'],
          'org_state_location' => $fields['org_state_location'],
          'outside_ss' => $fields['outside_ss'],
          'mission' => $fields['mission'],
          'vision' => $fields['vision'],
          'area_of_focus' => $fields['area_of_focus'],
          'grp_feminist' => $fields['grp_feminist'],
          'experience' => $fields['experience'],
          'org_gain' => $fields['org_gain']
          ));
    
        $ajax_handler->add_response_data( true, $output );
    
        }

}, 10, 2);